//******************************************
// file			: ADC.c
// version		: V1.0
// brief		: ADC related functions
// note			: ADC related functions are gathered in this subroutine
//****************************************** 

#include "MQ6821.h"
#include "MQ6812_REG_BIT.h"

//-- header guards --//
#define uchar unsigned char
#define uint  unsigned int
#define ulong unsigned long

#define	ad_test_times	8
			
ulong ADC_buf;
ulong adc_value;
uint Real_Vref2V;
unsigned int GetVref(void);
extern ulong ADC_Converse(char Vref ,char AIN);
ulong ADC_detect(char Vref ,char AIN);

uchar Flag;
uint verf_2v;
//uchar verf_l,verf_h;




//*********************************************************************
// name			: GetVref()
// brief		: get the value of internal ADC reference voltage (unit: mV)
// note			:
//*********************************************************************
// (0x7E63)    VREF2V_h;		/* VREF2V measurement high byte(mV) by CP */
//(0x7E64)    VREF2V_l;		/* VREF2V measurement low byte(mV) by CP */ 

uint GetVref(void)
{
	__asm("LD E,(0x7E05)");		// low byte
	__asm("LD D,(0x7E06)");		// high byte

//	verf_2v = (uint)verf_h*256 + verf_l;	// mv
	
	verf_2v=__DE;
	
	if(verf_2v>2100)verf_2v=2000;
	if(verf_2v<1900)verf_2v=2000;	
	
	return verf_2v;
}

ulong ADC_Converse(char Vref ,char AIN)
{  
	 ulong adc_Ain12=0;
  
   if(Flag==0){		Flag=1; 
                  Real_Vref2V = GetVref();
				  ADC_detect(Vref,AIN); 
				  }
   if(Vref==2){	
				adc_value = ADC_detect(2,AIN);//
				adc_Ain12 = ADC_detect(2,12);//internal offset
			
			//	subtract the ADC offset, compare the ADC result first, if the ADC result is less than the offset, then take the ADC result as 0
				if( adc_value> adc_Ain12 ) adc_value = adc_value- adc_Ain12;
					else	 adc_value = 0;
					
			   adc_value =(adc_value*Real_Vref2V ) /1024/ad_test_times;	//2000 //2048	
				
					__asm("nop");
							
			}
			
			
   else adc_value=ADC_detect(Vref,AIN)/ad_test_times;
   return adc_value;
   }
//*********************************************************************
// name			: ADC_detect()
// brief		: 16 conversion times and get the sum of results
// note			:
//*********************************************************************
ulong ADC_detect(char Vref ,char AIN)
{   	char  i;
	ulong adc_data = 0;	
//	ADCCR2.byte=0x05;//conversion times 16us	
	ADCCR2.byte=0x01;//conversion times 8us

   switch(Vref)
   { 
		case 2: ADCVRF.byte=0x00;break;
 	   	case 3: ADCVRF.byte=0x01;break;
   	 	case 4: ADCVRF.byte=0x02;break;
		case 5: ADCVRF.byte=0x03;break;	//VDD
		case 6: ADCVRF.byte=0x04;break;	//set ADC reference voltage to external voltage (AIN3)		
			
		default:ADCVRF.byte=0x03;break;	//VDD	
   }

    switch(AIN)
   {  
   	case 0: ADCCR1.byte=0x30;break;
   	case 1: ADCCR1.byte=0x31;break;
   	case 2: ADCCR1.byte=0x32;break;
   	case 3: ADCCR1.byte=0x33;break;
   	case 4: ADCCR1.byte=0x34;break;
   	case 5: ADCCR1.byte=0x35;break;
   	case 6: ADCCR1.byte=0x36;break;
    	case 7: ADCCR1.byte=0x37;break;
   	case 8: ADCCR1.byte=0x38;break;
  		
   	case 9: ADCCR1.byte=0x39;break;	//test 1/4 VDD
   	case 12: ADCCR1.byte=0x3c;break;	//ground use to ADC calibration
  
	default: break;
   }

//	__asm("DI");		
	for( i=0; i<ad_test_times; i++ )	
	{
		
		ADCCR1.bit.b7 = 1;			// start ADC sampling
		while( !ADCCR2.bit.b7 );	// wait for end of conversion

		(__L)=ADCDRL.byte;
		(__H)=(ADCDRH.byte&0x03);	
		
	//	ADC_buf=(ulong)ADCDRH.byte*256 + ADCDRL.byte;
	//	ADC_buf=(ulong)temp;
		ADC_buf=(ulong)__HL;
		ADC_buf&=0x000003ff;
		adc_data  += ADC_buf;
	}
	
	__asm("EI");		
	return adc_data;
}









